/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.inventory.sorting.mixin;

import com.nemonotfound.nemos.inventory.sorting.Constants;
import com.nemonotfound.nemos.inventory.sorting.client.config.ComponentConfig;
import com.nemonotfound.nemos.inventory.sorting.client.config.ConfigUtil;
import com.nemonotfound.nemos.inventory.sorting.client.gui.components.ContainerFilterBox;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1733;
import net.minecraft.class_1735;
import net.minecraft.class_1921;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_465;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_465.class})
public abstract class AbstractContainerScreenMixin
extends class_437 {
    @Shadow
    protected int field_2776;
    @Shadow
    protected int field_2800;
    @Unique
    private ContainerFilterBox nemosInventorySorting$containerFilterBox;
    @Unique
    private class_342 nemosInventorySorting$searchBox;
    @Unique
    private static final class_2960 HIGHLIGHTED_SLOT = class_2960.method_60655((String)"nemos_inventory_sorting", (String)"container/highlighted_slot");
    @Unique
    private static final class_2960 DIMMED_SLOT = class_2960.method_60655((String)"nemos_inventory_sorting", (String)"container/dimmed_slot");

    @Shadow
    public abstract class_1703 method_17577();

    protected AbstractContainerScreenMixin(class_2561 component) {
        super(component);
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    public void init(CallbackInfo ci) {
        if (this.nemosInventorySorting$shouldHaveSearchBox()) {
            List<ComponentConfig> configs = ConfigUtil.readConfigs();
            Optional<ComponentConfig> optionalComponentConfig = ConfigUtil.getConfigs(configs, Constants.ITEM_FILTER);
            if (optionalComponentConfig.isEmpty()) {
                this.nemosInventorySorting$createSearchBox(Constants.X_OFFSET_ITEM_FILTER, Constants.Y_OFFSET_ITEM_FILTER, Constants.ITEM_FILTER_WIDTH, Constants.ITEM_FILTER_HEIGHT);
                return;
            }
            ComponentConfig config = optionalComponentConfig.get();
            if (!config.isEnabled()) {
                return;
            }
            int yOffset = config.yOffset() != null ? config.yOffset() : Constants.Y_OFFSET_ITEM_FILTER;
            this.nemosInventorySorting$createSearchBox(config.xOffset(), yOffset, config.width(), config.height());
        }
    }

    @Unique
    private void nemosInventorySorting$createSearchBox(int xOffset, int yOffset, int width, int height) {
        this.nemosInventorySorting$containerFilterBox = new ContainerFilterBox(this.field_22793, this.field_2776, this.field_2800, xOffset, yOffset, width, height);
        this.nemosInventorySorting$searchBox = this.nemosInventorySorting$containerFilterBox.getSearchBox();
        this.method_25429((class_364)this.nemosInventorySorting$searchBox);
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    public void keyPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (this.nemosInventorySorting$shouldHaveSearchBox() && this.nemosInventorySorting$searchBox != null && this.nemosInventorySorting$searchBox.method_25370() && keyCode != 256) {
            cir.setReturnValue((Object)this.nemosInventorySorting$searchBox.method_25404(keyCode, scanCode, modifiers));
        }
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    void render(class_332 guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        if (!this.nemosInventorySorting$shouldHaveSearchBox() || this.nemosInventorySorting$searchBox == null) {
            return;
        }
        this.nemosInventorySorting$searchBox.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        String filter = this.nemosInventorySorting$searchBox.method_1882();
        if (!filter.isEmpty()) {
            Map<Boolean, List<class_1735>> filteredSlotMap = this.nemosInventorySorting$containerFilterBox.filterSlots((class_2371<class_1735>)this.method_17577().field_7761, filter);
            this.nemosInventorySorting$markSlots(false, filteredSlotMap.get(true), guiGraphics, HIGHLIGHTED_SLOT);
            this.nemosInventorySorting$markSlots(true, filteredSlotMap.get(false), guiGraphics, DIMMED_SLOT);
        }
    }

    @Unique
    private boolean nemosInventorySorting$shouldHaveSearchBox() {
        return this.method_17577() instanceof class_1707 || this.method_17577() instanceof class_1733;
    }

    @Unique
    private void nemosInventorySorting$markSlots(boolean shouldFillGradient, List<class_1735> slots, class_332 guiGraphics, class_2960 texture) {
        for (class_1735 slot : slots) {
            int xPos = this.field_2776 + slot.field_7873;
            int yPos = this.field_2800 + slot.field_7872;
            guiGraphics.method_52706(texture, xPos, yPos, 16, 16);
            if (!shouldFillGradient) continue;
            guiGraphics.method_51740(class_1921.method_51785(), xPos, yPos, xPos + 16, yPos + 16, -2139062142, -2139062142, 0);
        }
    }
}

